<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Deliveriy extends Model 
{

    protected $table = 'deliveries';
    public $timestamps = true;
    protected $fillable = array('user_name', 'email', 'status', 'last_login', 'latitude', 'longitude', 'mute_notification');

    public function contacts()
    {
        return $this->morphMany('App\Models\Contact', 'contactable');
    }

    public function credit_cards()
    {
        return $this->morphMany('App\Models\CreditCard', 'cardable');
    }

    public function orders()
    {
        return $this->belongsToMany('App\Models\Order');
    }

    public function clientReviews()
    {
        return $this->hasMany('App\Models\ClientReview');
    }

    public function serviceProviderReviews()
    {
        return $this->morphMany('App\Models\Review');
    }

}